% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uniform.R
\name{quantile.Uniform}
\alias{quantile.Uniform}
\title{Determine quantiles of a continuous Uniform  distribution}
\usage{
\method{quantile}{Uniform}(d, p, ...)
}
\arguments{
\item{d}{A \code{Uniform} object created by a call to \code{\link[=Uniform]{Uniform()}}.}

\item{p}{A vector of probabilites.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of quantiles, one for each element of \code{p}.
}
\description{
\code{quantile()} is the inverse of \code{cdf()}.
}
\examples{

set.seed(27)

X <- Uniform(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))

}
