% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gumbel.R
\name{cdf.Gumbel}
\alias{cdf.Gumbel}
\title{Evaluate the cumulative distribution function of a Gumbel distribution}
\usage{
\method{cdf}{Gumbel}(d, x, ...)
}
\arguments{
\item{d}{A \code{Gumbel} object created by a call to \code{\link[=Gumbel]{Gumbel()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the cumulative distribution function of a Gumbel distribution
}
\examples{

set.seed(27)

X <- Gumbel(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
