% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binomial.R
\name{pdf.Binomial}
\alias{pdf.Binomial}
\alias{log_pdf.Binomial}
\title{Evaluate the probability mass function of a Binomial distribution}
\usage{
\method{pdf}{Binomial}(d, x, ...)

\method{log_pdf}{Binomial}(d, x, ...)
}
\arguments{
\item{d}{A \code{Binomial} object created by a call to \code{\link[=Binomial]{Binomial()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the probability mass function of a Binomial distribution
}
\examples{

set.seed(27)

X <- Binomial(10, 0.2)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2L)
log_pdf(X, 2L)

cdf(X, 4L)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
