% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exponential.R
\name{random.Exponential}
\alias{random.Exponential}
\title{Draw a random sample from an Exponential distribution}
\usage{
\method{random}{Exponential}(x, n = 1L, ...)
}
\arguments{
\item{x}{An \code{Exponential} object created by a call to \code{\link[=Exponential]{Exponential()}}.}

\item{n}{The number of samples to draw. Defaults to \code{1L}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Draw a random sample from an Exponential distribution
}
\examples{

set.seed(27)

X <- Exponential(5)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
