% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{fit_mle}
\alias{fit_mle}
\title{Fit a distribution to data}
\usage{
fit_mle(d, x, ...)
}
\arguments{
\item{d}{A probability distribution object such as those created by
a call to \code{\link[=Bernoulli]{Bernoulli()}}, \code{\link[=Beta]{Beta()}}, or \code{\link[=Binomial]{Binomial()}}.}

\item{x}{A vector of data to compute the likelihood.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A distribution (the same kind as \code{d}) where the parameters
are the MLE estimates based on \code{x}.
}
\description{
Approximates an empirical distribution with a theoretical one
}
\examples{

X <- Normal()

fit_mle(X, c(-1, 0, 0, 0, 3))
}
