% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{Beta}
\alias{Beta}
\title{Create a Beta distribution}
\usage{
Beta(alpha = 1, beta = 1)
}
\arguments{
\item{alpha}{The alpha parameter. \code{alpha} can be any value strictly
greater than zero. Defaults to \code{1}.}

\item{beta}{The beta parameter. \code{beta} can be any value strictly
greater than zero. Defaults to \code{1}.}
}
\value{
A \code{beta} object.
}
\description{
Create a Beta distribution
}
\examples{

set.seed(27)

X <- Beta(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

mean(X)
variance(X)
skewness(X)
kurtosis(X)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
\seealso{
Other continuous distributions: 
\code{\link{Cauchy}()},
\code{\link{ChiSquare}()},
\code{\link{Erlang}()},
\code{\link{Exponential}()},
\code{\link{FisherF}()},
\code{\link{Frechet}()},
\code{\link{GEV}()},
\code{\link{GP}()},
\code{\link{Gamma}()},
\code{\link{Gumbel}()},
\code{\link{LogNormal}()},
\code{\link{Logistic}()},
\code{\link{Normal}()},
\code{\link{RevWeibull}()},
\code{\link{StudentsT}()},
\code{\link{Tukey}()},
\code{\link{Uniform}()},
\code{\link{Weibull}()}
}
\concept{continuous distributions}
