% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diversity.R
\name{dim_variety}
\alias{dim_variety}
\title{Variety or Richness}
\usage{
dim_variety(data, sort = TRUE, decreasing = TRUE, entity_col = FALSE)
}
\arguments{
\item{data}{A numeric matrix with entities \eqn{i} in the rows and categories \eqn{j} in the columns. Cells show the respective value (value of abundance) of entity \eqn{i} in the category \eqn{j}. It can also be a transpose of the previous matrix, that is, a matrix with categories in the rows and entities in the columns. Yet in that case, the parameter "entity_col" has to be set to TRUE. The matrix must include names for the rows and the columns. The parameter "data", also accepts a dataframe with three columns in the following order: entity, category and value.}

\item{sort}{Indicates whether results should be ordered or not. Define it to FALSE to avoid ordering.}

\item{decreasing}{If parameter "sort" is set to TRUE, this parameter indicates descending order. The default value is TRUE.}

\item{entity_col}{A flag to indicate that entities are in the columns. The analysis assumes that the entities are in the rows of the matrix. If the entities are in the columns and the categories in the rows, then the parameter "entity_col" has to be set to TRUE. The default value is FALSE.}
}
\value{
A dataframe with values of variety for each entity.
}
\description{
It computes the variety (number of distinct types) or simple diversity of an entity. It is also known as richness.
}
\examples{
dim_variety(data=pantheon)
dim_variety(data=pantheon, sort=FALSE)
}

