% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_spatial.R
\name{spat.beta}
\alias{spat.beta}
\title{Spatial beta diversity for raster}
\usage{
spat.beta(
  x,
  tree,
  filename = "",
  global = FALSE,
  fm = NULL,
  d = mean(terra::res(terra::rast(x))) * 2,
  type = "circle",
  na.policy = "omit",
  ...
)
}
\arguments{
\item{x}{A SpatRaster with presence-absence data (0 or 1) for a
set of species.}

\item{tree}{A data.frame with species traits or a phylogenetic
tree.}

\item{filename}{Character. Save results if a name is provided.}

\item{global}{Logical. Mean of pairwise comparisons between
focal cell and its neighbors (default) or mean of all pairwise
comparisons.}

\item{fm}{Numeric. Focal matrix ("moving window").}

\item{d}{Window radius to compute beta diversity.}

\item{type}{Character. Window format. Default = "circle".}

\item{na.policy}{Character. Default = "omit".
See ?terra::focal3D for details.}

\item{...}{Additional arguments to be passed passed down from
a calling function.}
}
\value{
A SpatRaster with beta results (total, replacement,
and richness differences).
}
\description{
Calculates spatial beta diversity for
taxonomic (TD), functional (FD), and phylogenetic (PD)
dimensions. Adapted from \code{\link[BAT]{beta}}
}
\details{
The TD beta diversity partitioning framework we used
was developed by Podani and Schmera (2011) and Carvalho et al.
(2012) and expanded to PD and FD by Cardoso et al. (2014).
}
\examples{
\donttest{
library(terra)
bin1 <- terra::rast(system.file("extdata", "ref.tif",
package = "divraster"))
traits <- read.csv(system.file("extdata", "traits.csv",
package = "divraster"), row.names = 1)
rownames(traits) <- names(bin1)
tree <- ape::read.tree(system.file("extdata", "tree.tre",
package = "divraster"))
spat.beta(bin1)
spat.beta(bin1, traits)
spat.beta(bin1, tree)
}
}
\references{
Cardoso, P. et al. 2014. Partitioning taxon,
phylogenetic and functional beta diversity into replacement
and richness difference components. - Journal of Biogeography
41: 749–761.

Carvalho, J. C. et al. 2012. Determining the
relative roles of species replacement and species richness
differences in generating beta-diversity patterns. - Global
Ecology and Biogeography 21: 760–771.

Podani, J. and Schmera, D. 2011. A new conceptual
and methodological framework for exploring and explaining
pattern in presence - absence data. - Oikos 120: 1625–1638.
}
