% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.hdlm.R
\name{predict.hdlm}
\alias{predict.hdlm}
\title{Calculates predicted response for HDLM}
\usage{
\method{predict}{hdlm}(
  object,
  new.data,
  new.exposure.data,
  ci.level = 0.95,
  type = "response",
  outcome = NULL,
  fixed.idx = list(),
  est.dlm = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{fitted dlmtree model with class hdlm}

\item{new.data}{new data frame which contains the same covariates and modifiers used to fit HDLM model}

\item{new.exposure.data}{new data frame/list which contains the same length of exposure lags used to fit HDLM model}

\item{ci.level}{credible interval level for posterior predictive distribution}

\item{type}{type of prediction: "response" (default) or "waic". "waic" must be specified with `outcome` parameter}

\item{outcome}{outcome required for WAIC calculation}

\item{fixed.idx}{fixed index}

\item{est.dlm}{flag for estimating dlm effect}

\item{verbose}{TRUE (default) or FALSE: print output}

\item{...}{additional parameters}
}
\value{
Posterior predictive distribution draws
}
\description{
Method for calculating predicted response for HDLM
}
\details{
predict.hdlm
}
