% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normality.R
\name{get_transform}
\alias{get_transform}
\title{Transform a numeric vector}
\usage{
get_transform(
  x,
  method = c("log", "sqrt", "log+1", "log+a", "1/x", "x^2", "x^3", "Box-Cox",
    "Yeo-Johnson")
)
}
\arguments{
\item{x}{numeric. numeric for transform}

\item{method}{character. transformation method of numeric variable}
}
\value{
numeric. transformed numeric vector.
}
\description{
The get_transform() gets transformation of numeric variable.
}
\details{
The supported transformation method is follow.: 
\itemize{
  \item "log" : log transformation. log(x)
  \item "log+1" : log transformation. log(x + 1). Used for values that contain 0.
  \item "log+a" : log transformation. log(x + 1 - min(x)). Used for values that contain 0.   
  \item "sqrt" : square root transformation.
  \item "1/x" : 1 / x transformation
  \item "x^2" : x square transformation
  \item "x^3" : x^3 square transformation
  \item "Box-Cox" : Box-Box transformation
  \item "Yeo-Johnson" : Yeo-Johnson transformation
}
}
\examples{
\dontrun{
# log+a transform 
get_transform(iris$Sepal.Length, "log+a")

if (requireNamespace("forecast", quietly = TRUE)) {
  # Box-Cox transform 
  get_transform(iris$Sepal.Length, "Box-Cox")

  # Yeo-Johnson transform 
  # get_transform(iris$Sepal.Length, "Yeo-Johnson")
} else {
  cat("If you want to use this feature, you need to install the forecast package.\n")
}
}

}
\seealso{
\code{\link{plot_normality}}.
}
