% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_dbi.R
\name{get_column_info}
\alias{get_column_info}
\title{Describe column of table in the DBMS}
\usage{
get_column_info(df)
}
\arguments{
\item{df}{a tbl_dbi.}
}
\value{
An object of data.frame.
}
\description{
The get_column_info() retrieves the column information of the DBMS table through the tbl_bdi object of dplyr.
}
\section{Column information of the DBMS table}{


\itemize{
  \item SQLite DBMS connected RSQLite::SQLite(): 
  \itemize{
    \item name: column name
    \item type: data type in R
  }
  \item MySQL/MariaDB DBMS connected RMySQL::MySQL(): 
  \itemize{
    \item name: column name
    \item Sclass: data type in R
    \item type: data type of column in the DBMS
    \item length: data length in the DBMS   
  }
  \item Oracle DBMS connected ROracle::dbConnect(): 
  \itemize{
    \item name: column name
    \item Sclass: column type in R
    \item type: data type of column in the DBMS
    \item len: length of column(CHAR/VARCHAR/VARCHAR2 data type) in the DBMS
    \item precision: precision of column(NUMBER data type) in the DBMS
    \item scale: decimal places of column(NUMBER data type) in the DBMS
    \item nullOK: nullability
  }
}
}

\examples{
\donttest{
library(dplyr)
# connect DBMS
con_sqlite <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

# copy heartfailure to the DBMS with a table named TB_HEARTFAILURE
copy_to(con_sqlite, heartfailure, name = "TB_HEARTFAILURE", overwrite = TRUE)

con_sqlite \%>\% 
  tbl("TB_HEARTFAILURE") \%>\% 
  get_column_info
  
# Disconnect DBMS   
DBI::dbDisconnect(con_sqlite)
}

}
