% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{dm_bind}
\alias{dm_bind}
\title{Merge several \code{dm}}
\usage{
dm_bind(..., repair = "check_unique", quiet = FALSE)
}
\arguments{
\item{...}{\code{dm} objects to bind together.}

\item{repair}{Either a string or a function. If a string, it must
be one of \code{"check_unique"}, \code{"minimal"}, \code{"unique"}, or \code{"universal"}.
If a function, it is invoked with a vector of minimal names and must
return minimal names, otherwise an error is thrown.
\itemize{
\item Minimal names are never \code{NULL} or \code{NA}. When an element doesn't
have a name, its minimal name is an empty string.
\item Unique names are unique. A suffix is appended to duplicate
names to make them unique.
\item Universal names are unique and syntactic, meaning that you can
safely use the names as variables without causing a syntax
error.
}

The \code{"check_unique"} option doesn't perform any name repair.
Instead, an error is raised if the names don't suit the
\code{"unique"} criteria.}

\item{quiet}{By default, the user is informed of any renaming
caused by repairing the names. This only concerns unique and
universal repairing. Set \code{quiet} to \code{TRUE} to silence the
messages.

Users can silence the name repair messages by setting the
\code{"rlib_name_repair_verbosity"} global option to \code{"quiet"}.}
}
\value{
\code{dm} containing the tables and key relations of all \code{dm} objects.
}
\description{
Create a single \code{dm} from two or more \code{dm} objects.
}
\details{
The \code{dm} objects have to share the same \code{src}. By default table names need to be unique.
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dm_1 <- dm_nycflights13()
dm_2 <- dm(mtcars, iris)
dm_bind(dm_1, dm_2)
\dontshow{\}) # examplesIf}
}
