% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{glimpse.dm}
\alias{glimpse.dm}
\alias{glimpse.dm_zoomed}
\title{Get a glimpse of your \code{dm} object}
\usage{
\method{glimpse}{dm}(x, width = NULL, ...)

\method{glimpse}{dm_zoomed}(x, width = NULL, ...)
}
\arguments{
\item{x}{A \code{dm} object.}

\item{width}{Controls the maximum number of columns on a line used in
printing. If \code{NULL}, \code{getOption("width")} will be consulted.}

\item{...}{Passed to \code{\link[pillar:glimpse]{pillar::glimpse()}}.}
}
\description{
\code{glimpse()} provides an overview (dimensions, column data types, primary
keys, etc.) of all tables included in the \code{dm} object. It will additionally
print details about outgoing foreign keys for the child table.

\code{glimpse()} is provided by the pillar package, and re-exported by {dm}.
See \code{\link[pillar:glimpse]{pillar::glimpse()}} for more details.
}
\examples{

dm_nycflights13() \%>\% glimpse()

dm_nycflights13() \%>\%
  dm_zoom_to(flights) \%>\%
  glimpse()

}
