% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna.R
\name{[[.dnapath}
\alias{[[.dnapath}
\title{Extract results of a single pathway from a 'dnapath' object.}
\usage{
\method{[[}{dnapath}(x, i, ...)
}
\arguments{
\item{x}{A 'dnapath' object.}

\item{i}{The index specifying which pathway to extract.}

\item{...}{Additional arguments are ignored.}
}
\value{
The 'dnapath' object unmodified
}
\description{
Extract results of a single pathway from a 'dnapath' object.
}
\note{
In the current implementation, there is nothing to subset on for
individual pathway results, so the original object is returned unmodified.
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways[[1]],
                   group_labels = meso$groups, n_perm = 10)
results[[1]]
}
