\docType{package}
\name{doRNG-package}
\alias{doRNG-package}
\title{Generic Reproducible Parallel Backend for foreach Loops}
\description{
  The \emph{doRNG} package provides functions to perform
  reproducible parallel foreach loops, using independent
  random streams as generated by L'Ecuyer's combined
  multiple-recursive generator [L'Ecuyer (1999)]. It
  enables to easily convert standard %dopar% loops into
  fully reproducible loops, independently of the number of
  workers, the task scheduling strategy, or the chosen
  parallel environment and associated foreach backend. It
  has been tested with the following foreach backend: doMC,
  doSNOW, doMPI.
}
\details{
  \tabular{ll}{ Package: \tab doRNG\cr Type: \tab
  Package\cr Version: \tab 1.0.1\cr Date: \tab
  2011-10-21\cr License: \tab GPL (>= 2)\cr LazyLoad: \tab
  yes\cr }
}
\examples{
if( require(doMC) ){

library(doMC)
registerDoMC()

unlist(foreach(i=1:4, .options.RNG=123) \%dorng\%{ runif(1) })
unlist(foreach(i=1:4, .options.RNG=123) \%dorng\%{ runif(1) })

registerDoRNG(1234)
unlist(foreach(i=1:4) \%dopar\%{ runif(1) })

}
}
\author{
  Renaud Gaujoux \email{renaud@cbio.uct.ac.za},

  Maintainer: Renaud Gaujoux \email{renaud@cbio.uct.ac.za},
}
\seealso{
  \code{\link{doRNG}}, \code{\link{RNGseq}}
}
\keyword{package}

