% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{buildf}
\alias{buildf}
\title{Build Density}
\usage{
buildf(margins, copula, names = NULL)
}
\arguments{
\item{margins}{either \itemize{
\item \code{function(y, theta, ...)}, where \code{theta} is a list of parameters.
It shall return a column matrix of two, the probability densities and cumulative distributions.
\item list of pairs of expressions, named \code{"pdf"} and \code{"cdf"}, the probability density and cumulative distribution.
}}

\item{copula}{a copula object from package \pkg{copula}.}

\item{names}{(if \code{margins} is a function) a vector of names or indices, the sequence of copula parameters in \code{theta}.
\code{0} or \code{""} identifies copula parameters to omit.}
}
\value{
\code{buildf} returns either \itemize{
\item \code{function(y, theta, ...)}, the joint probability density function, if \code{margins} is a function.
\item the joint probabilty density as an expression, otherwise.
}
}
\description{
\code{buildf} builds the joint probabilty density given the marginal distributions and some copula.
}
\details{
If \code{buildf} should build an expression, the copula shall provide distribution expressions.
Please note that expressions are not validated.
}
\examples{
## for an actual use case see examples for param

library(copula)
library(mvtnorm)

## build bivariate normal pdf
margins = function(y, theta) {
    mu = c(theta$mu1, theta$mu2)
    cbind(dnorm(y, mu), pnorm(y, mu))
}
copula = copula::normalCopula()

f = buildf(margins, copula, 'alpha')
f

## plot density
theta = list(mu1=2, mu2=-3, alpha=0.4)
y1 = seq(0, 4, length.out=51)
y2 = seq(-5, -1, length.out=51)
z = outer(y1, y2, function(y1, y2) apply(cbind(y1, y2), 1, f, theta))
contour(y1, y2, z)

## add theoretical density
copula@parameters = theta$alpha
z2 = outer(y1, y2, function(y1, y2)
    dmvnorm(cbind(y1 - theta$mu1, y2 - theta$mu2), sigma=getSigma(copula)))
contour(y1, y2, z2, col='red', add=TRUE)

## build bivariate pdf with normal margins and clayton copula
margins = list(alist(pdf=dnorm(y1, mu1, 1),
                     cdf=pnorm(y1, mu1, 1)),
               alist(pdf=dnorm(y2, mu2, 1),
                     cdf=pnorm(y2, mu2, 1)))
copula = claytonCopula()
ff = buildf(margins, copula)
f = expr2f(ff, yMap=list(y1=1, y2=2),
               thetaMap=list(mu1='mu1', mu2='mu2', alpha='alpha'))
f

margins = function(y, theta) {
    mu = c(theta$mu1, theta$mu2)
    cbind(dnorm(y, mu, 1), pnorm(y, mu, 1))
}
f2 = buildf(margins, copula, 'alpha')
f2

## plot both densities
theta = list(mu1=2, mu2=-3, alpha=2) # tau = 0.5

y1 = seq(0, 4, length.out=51)
y2 = seq(-5, -1, length.out=51)
z = outer(y1, y2, function(y1, y2) apply(cbind(y1, y2), 1, f, theta))
contour(y1, y2, z)

z2 = outer(y1, y2, function(y1, y2) apply(cbind(y1, y2), 1, f2, theta))
contour(y1, y2, z2, col='red', add=TRUE)
}
\references{
uses substitute_q from \url{http://adv-r.had.co.nz/Computing-on-the-language.html}
}
\seealso{
\pkg{copula}, \code{\link{expr2f}}, \code{\link{numDerivLogf}}, \code{\link{DerivLogf}}, \code{\link{fisherI}}
}

