% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{numDerivLogf}
\alias{numDeriv2Logf}
\alias{numDerivLogf}
\title{Build Derivative Function for Log f}
\usage{
numDerivLogf(f, isLogf = FALSE, logZero = .Machine$double.xmin,
  logInf = .Machine$double.xmax/2, method = "Richardson",
  method.args = list())

numDeriv2Logf(f, isLogf = FALSE, logZero = .Machine$double.xmin,
  logInf = .Machine$double.xmax/2, method = "Richardson",
  method.args = list())
}
\arguments{
\item{f}{\code{function(y, theta, ...)}, where \code{theta} is a list of parameters.
A joint probability density function.}

\item{isLogf}{set to \code{TRUE} if \code{f} is already \code{log(f)}.}

\item{logZero}{the value \code{log(f)} should return if \code{f} evaluates to \code{0}.}

\item{logInf}{the value \code{log(f)} should return if \code{f} evaluates to \code{Inf}.}

\item{method}{see \pkg{numDeriv}.}

\item{method.args}{see \pkg{numDeriv}.}
}
\value{
\code{numDerivLogf} returns \code{function(y, theta, i, ...)} which evaluates to the first derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]}.

\code{numDeriv2Logf} returns \code{function(y, theta, i, j, ...)} which evaluates to the second derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]} and \code{theta[[j]]}.
}
\description{
Builds a function that evaluates to the first/second derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]}/\code{theta[[i]]} and \code{theta[[j]]}.
}
\details{
\pkg{numDeriv} produces \code{NaN}s if the log evaluates to (negative) \code{Inf} so you may want to specify \code{logZero} and \code{logInf}.
}
\examples{
## see examples for param
}
\seealso{
\pkg{numDeriv}, \code{\link{buildf}}, \code{\link{DerivLogf}}, \code{\link{fisherI}}
}

