% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{runCorrelationTest}
\alias{runCorrelationTest}
\title{Run correlationTest, based on https://doi.org/10.1111/2041-210X.12466}
\usage{
runCorrelationTest(
  phy,
  clone,
  permutations,
  minlength = 0.001,
  polyresolve = TRUE,
  permutation = c("clustered", "uniform"),
  time = "time",
  sequence = "sequence_id",
  germline = "Germline",
  verbose = TRUE,
  alternative = c("greater", "two.sided")
)
}
\arguments{
\item{phy}{Tree object}

\item{clone}{airrClone data object corresponding to \code{phy}}

\item{permutations}{Number of permutations to run}

\item{minlength}{Branch lengths to collapse in trees}

\item{polyresolve}{Resolve polytomies to have a minimum number of 
single timepoint clades}

\item{permutation}{Permute among single timepoint clades or uniformly
among tips}

\item{time}{Column name holding numeric time information}

\item{sequence}{Column name holding sequence ID}

\item{germline}{Germline sequence name}

\item{verbose}{Print lots of rubbish while running?}

\item{alternative}{Is alternative that the randomized correlation are greater than 
or equal to observed, or greater/less than?}
}
\value{
A list of statistics from running the permutation test.
}
\description{
\code{runCorrelationTest} performs root-to-tip regression permutation test
}
\details{
See \link{correlationTest} for details
}
\seealso{
\link{correlationTest}.
}
