% Generated by roxygen2 (4.0.1): do not edit by hand
\name{rbind_all}
\alias{rbind_all}
\alias{rbind_list}
\title{Efficiently rbind multiple data frames.}
\usage{
rbind_all(dots)

rbind_list(...)
}
\arguments{
\item{dots,...}{list of data frames to combine. With \code{rbind_all},
they should already be in a list, with \code{rbind_list} you supply
them individually.}
}
\description{
This is an efficient version of the common pattern of
\code{do.call(rbind, dfs)} for row-binding many data frames together.
It works in the same way as \code{\link[plyr]{rbind.fill}} but is
implemented in C++ so avoids many copies and is much much faster.
}
\examples{
one <- mtcars[1:10, ]
two <- mtcars[11:32, ]

rbind_list(one, two)
rbind_all(list(one, two))
}

