% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{posterior}
\alias{posterior}
\alias{posterior.dreamer}
\alias{posterior.dreamer_mcmc_independent}
\alias{posterior.dreamer_bma}
\title{Posterior Quantities from Bayesian Model Averaging}
\usage{
posterior(
  x,
  doses,
  times,
  probs,
  reference_dose,
  predictive,
  return_samples,
  iter,
  return_stats
)

\method{posterior}{dreamer}(
  x,
  doses = attr(x, "doses"),
  times = attr(x, "times"),
  probs = c(0.025, 0.975),
  reference_dose = NULL,
  predictive = 0,
  return_samples = FALSE,
  iter = NULL,
  return_stats = TRUE
)

\method{posterior}{dreamer_mcmc_independent}(
  x,
  doses = attr(x, "doses"),
  times = attr(x, "times"),
  probs = c(0.025, 0.975),
  reference_dose = NULL,
  predictive = 0,
  return_samples = FALSE,
  iter = NULL,
  return_stats = TRUE
)

\method{posterior}{dreamer_bma}(
  x,
  doses = x$doses,
  times = x$times,
  probs = c(0.025, 0.975),
  reference_dose = NULL,
  predictive = 0,
  return_samples = FALSE,
  iter = NULL,
  return_stats = TRUE
)
}
\arguments{
\item{x}{output from a call to \code{\link{dreamer_mcmc}}.}

\item{doses}{doses at which to estimate posterior quantities.}

\item{times}{a vector of times at which to calculate the posterior response
(for longitudinal models only).}

\item{probs}{quantiles of the posterior to be calculated.}

\item{reference_dose}{the dose at which to adjust the posterior plot.
Specifying
a dose returns the plot of pr(trt_dose - trt_{reference_dose} | data).}

\item{predictive}{An integer.  If greater than 0, the return values will
be from the predictive distribution of the mean of \code{predictive}
observations.
If 0 (default), the posterior on the dose response mean is returned.}

\item{return_samples}{logical indicating if the weighted raw
MCMC samples from the Bayesian model averaging used to calculate the
mean and quantiles should be returned.}

\item{iter}{an index on which iterations of the MCMC should be used
in the calculations.  By default, all MCMC iterations are used.}

\item{return_stats}{logical indicating whether or not the posterior
statistics should be calculated.}
}
\value{
A named list with the following elements:
\itemize{
\item stats: a tibble the dose, posterior mean, and posterior quantiles.
\item samps: the weighted posterior samples.  Only returned if
\code{return_samples = TRUE}.
}
}
\description{
Calculate posterior mean (and quantiles for specific
doses for each MCMC iteration of the model.
}
\section{Methods (by class)}{
\itemize{
\item \code{dreamer}: posterior summary for linear model.

\item \code{dreamer_mcmc_independent}: posterior summary for independent model.

\item \code{dreamer_bma}: posterior summary for Bayesian model averaging fit.
}}

\examples{
set.seed(888)
data <- dreamer_data_linear(
  n_cohorts = c(20, 20, 20),
  dose = c(0, 3, 10),
  b1 = 1,
  b2 = 3,
  sigma = 5
)

# Bayesian model averaging
output <- dreamer_mcmc(
 data = data,
 n_adapt = 1e3,
 n_burn = 1e3,
 n_iter = 1e4,
 n_chains = 2,
 silent = FALSE,
 mod_linear = model_linear(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 ),
 mod_quad = model_quad(
   mu_b1 = 0,
   sigma_b1 = 1,
   mu_b2 = 0,
   sigma_b2 = 1,
   mu_b3 = 0,
   sigma_b3 = 1,
   shape = 1,
   rate = .001,
   w_prior = 1 / 2
 )
)

posterior(output)

# return posterior samples of the mean
post <- posterior(output, return_samples = TRUE)
head(post$samps)

# from a single model
posterior(output$mod_quad)

# posterior of difference of doses
posterior(output, reference_dose = 0)
}
