% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dr_correctTwo.R
\name{dr_correctTwo}
\alias{dr_correctTwo}
\title{Two-point drift correction}
\usage{
dr_correctTwo(.data, sourceVar, cleanVar, calValLow, calStdLow,
                      calValHigh, calStdHigh, factorVar)
}
\arguments{
\item{.data}{A tbl}

\item{sourceVar}{Name of variable to correct}

\item{cleanVar}{New variable name for corrected data}

\item{calValLow}{A numeric value; the number that the instrument was actually reading for
the low standard}

\item{calStdLow}{A numeric value; the number that the instrument should have been reading
for that standard; i.e. the low standard value}

\item{calValHigh}{A numeric value; the number that the instrument was actually reading
for the high standard}

\item{calStdHigh}{A numeric value; the number that the instrument should have been reading
for that standard; i.e. the high standard value}

\item{factorVar}{Name of variable generated using \code{\link{dr_factor}}}
}
\value{
An object of the same class as \code{.data} with the new corrected variable added
to the other data in \code{.data}.
}
\description{
A wrapper around \code{dplyr::mutate()} that creates a corrected value for each observation of the
    specified variable based on two data points.
}
\details{
This command takes the raw data from the water-quality instrument, utilizes the values
   generated from \code{\link{dr_factor}} and returns data that accounts for drift over time.
   This is done via a two-point calibration standard, which it typical for pH and chloride.
}
\examples{
testData <- data.frame(
   Date = c("9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015", "9/18/2015"),
   Time = c("12:10:49", "12:15:50", "12:20:51", "12:25:51", "12:30:51", "12:35:51"),
   Temp = c(14.76, 14.64, 14.57, 14.51, 14.50, 14.63),
   pH = c(7.18, 7.14, 7.14, 7.13, 7.13, 7.13),
   corrFac = c(0.0000000, 0.2003995, 0.4007989, 0.6005326, 0.8002663, 1.0000000),
   stringsAsFactors = FALSE
 )

 dr_correctTwo(testData, sourceVar = pH, cleanVar = pH_Corr, calValLow = 7.01, calStdLow = 7,
     calValHigh = 11.8, calStdHigh =  10, factorVar = corrFac)

}
\seealso{
\code{\link{dr_factor}} for correction factor creation,
    \code{\link{dr_correctOne}} for the two-point drift correction
}
