% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{getBootTaus}
\alias{getBootTaus}
\title{Run nonparametric bootstrap on the interaction index model}
\usage{
getBootTaus(fit, niter = 100, resample = c("all", "mono",
  "stratified"), seed = NULL, verbose = FALSE, ...)
}
\arguments{
\item{fit}{A \code{HarbronFit} object returned by 
\code{\link{fitModel}}.}

\item{niter}{Number of bootstrap samples to use.}

\item{resample}{Resampling method for bootstrap. Either "all" (default) for 
resampling from all data, "mono" for separately resampling monotherapy and 
combination data, or "stratified" for resampling at each dose combination 
separately. Note that the latter method is not meaningful if there are no 
replicates in the data.}

\item{seed}{Random seed to use for bootstrap}

\item{verbose}{Whether to show progress information.}

\item{...}{Further arguments passed to the \code{\link{fitModel}} calls.}
}
\value{
A matrix of interaction index estimates based on the bootstrap samples.
}
\description{
Function to run nonparametric bootstrap on the interaction index model.
It is usually called from \code{\link{getTauSurface}}.
}
\author{
Maxim Nazarov
}
