% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caseWhenDS.R
\name{caseWhenDS}
\alias{caseWhenDS}
\title{Performs dplyr case_when}
\usage{
caseWhenDS(tidy_expr = NULL, .default = NULL, .ptype = NULL, .size = NULL)
}
\arguments{
\item{tidy_expr}{A sequence of two-sided formulas. The left hand side (LHS) determines which
values match this case. The right hand side (RHS) provides the replacement value.
The LHS inputs must evaluate to logical vectors.
The RHS inputs will be coerced to their common type.
All inputs will be recycled to their common size. That said, we encourage all LHS inputs to be
the same size. Recycling is mainly useful for RHS inputs, where you might supply a size 1 input
that will be recycled to the size of the LHS inputs.
NULL inputs are ignored.}

\item{.default}{The value used when all of the LHS inputs return either FALSE or NA.}

\item{.ptype}{An optional prototype declaring the desired output type. If supplied, this overrides the common type of true, false, and missing.}

\item{.size}{An optional size declaring the desired output size. If supplied, this overrides the size of condition.}
}
\value{
A vector with the same size as the common size computed from the inputs in \code{tidy_expr} and the same type as the common type of the RHS inputs in \code{tidy_expr}.
}
\description{
DataSHIELD implentation of \code{dplyr::case_when}.
}
