% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_age_equivalent.R
\name{get_age_equivalent}
\alias{get_age_equivalent}
\title{Get age equivalents of items that have a difficulty estimate}
\usage{
get_age_equivalent(
  items,
  pct = c(10, 50, 90),
  key = NULL,
  itembank = dscore::builtin_itembank,
  population = NULL,
  xunit = c("decimal", "days", "months")
)
}
\arguments{
\item{items}{A character vector containing names of items to be
included into the D-score calculation. Milestone scores are coded
numerically as \code{1} (pass) and \code{0} (fail). By default,
D-score calculation is done on all items found in the data
that have a difficulty parameter under the specified \code{key}.}

\item{pct}{Numeric vector with requested percentiles (0-100). The
default is \code{pct = c(10, 50, 90)}.}

\item{key}{A string that selects a subset in the itembank that
makes up the key, the set of difficulty
estimates from a fitted Rasch model.
The built-in keys are:  \code{"gsed2212"} (default), \code{"gsed2208"} (deprecated),
\code{"gsed2206"} (deprecated), \code{"gsed1912"}, \code{"lf2206"}, \code{"sf2206"}, \code{"gcdg"},
and \code{"dutch"}. Since version 1.5.0, the \code{key = "gsed"}
selects the latest key starting with the string "gsed".
Use \code{key = ""} to use all item names,
which should only be done if there are no duplicate itemnames
in the itembank.}

\item{itembank}{A \code{data.frame} with columns
\code{key}, \code{item}, \code{tau}, \code{instrument}, \code{domain},
\code{mode}, \code{number} and \code{label}. Only columns \code{item}
and \code{tau} are required.
The function uses \code{dscore::builtin_itembank} by
default.}

\item{population}{A string describing the population. Currently
supported are \code{"phase1"} (default), \code{"dutch"}, \code{"gcdg"}.}

\item{xunit}{A string specifying the unit in which age is measured
(either \code{"decimal"}, \code{"days"} or \code{"months"}).
The default (\code{"decimal"}) means decimal age in years.}
}
\value{
Tibble with four columns: \code{item}, \code{d} (\emph{D}-score),
\code{pct} (percentile), and \code{a} (age-equivalent, in \code{xunit} units).
}
\description{
This function calculates the ages at which a certain percent
in the reference population passes the items.
}
\details{
The function internally defines a scale factor given the key.
}
\examples{
get_age_equivalent(c("gpagmc018", "gtogmd026", "ddicmm050"))
}
