\name{estSSMittnik}
\alias{estSSMittnik}
\title{Estimate a State Space Model}
\description{Estimate a state space model using Mittnik's markov parameter estimation.
}
\usage{
    estSSMittnik(data, max.lag=6, n=NULL, subtract.means=FALSE, normalize=FALSE)
}
\arguments{
    \item{data}{A TSdata object.}
    \item{max.lag}{The number of markov parameters to estimate.}
    \item{n}{The state dimension.}
    \item{subtract.means}{If TRUE subtract the means from the data before estimation.}
    \item{normalize}{If TRUE normalize the data before estimation.}
}
\value{A state space model in an object of class TSestModel.}
\details{
Estimate a nested-balanced state space model by svd from least squares
estimate of markov parameters a la Mittnik p1195 Comp.Math Appl.v17,1989.
The quality of the estimate seems to be quite sensitive to max.lag, 
and this is not properly resolved yet.
If n is not supplied the svd criteria will be printed and n prompted for.
If subtract.means=T then the sample mean is subtracted. 
If normalize is T the lsfit estimation is done with outputs normalize to cov=I
(There still seems to be something wrong here!!).
The model is then re-transformed to the original scale.

See MittnikReduction and references cited there. If the state
dimension is not specified then the singular values of the Hankel matrix are
printed and the user is prompted for the state dimension.
}
\references{
    See references for \code{\link{MittnikReduction}}. 
}
\seealso{
    \code{\link{MittnikReduction}}
    \code{\link{estVARXls}}
    \code{\link{bft}}
}
\examples{
    if(is.R()) data("egJofF.1dec93.data", package="dse1")
    \dontrun{model <- estSSMittnik(egJofF.1dec93.data)}
    # this prints information about singular values and prompts with
    #Enter the number of singular values to use for balanced model:
    # the choice is difficult in this example. 
    model <- estSSMittnik(egJofF.1dec93.data, n=3)
}
\concept{DSE}
\keyword{ts}

