% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reparametrize.R
\name{reparametrize}
\alias{reparametrize}
\title{reparametrize}
\usage{
reparametrize(
  mu = NULL,
  sigma_v = NULL,
  sigma_u = NULL,
  s = NULL,
  lambda = NULL,
  nu = NULL,
  xi = NULL,
  omega = NULL,
  alpha = NULL,
  delta = NULL,
  tau = NULL,
  mean = NULL,
  sd = NULL,
  skew = NULL,
  par_u = NULL,
  family = NULL
)
}
\arguments{
\item{mu}{vector of \eqn{\mu}}

\item{sigma_v}{vector of \eqn{\sigma_V}. Must be positive.}

\item{sigma_u}{vector of \eqn{\sigma_U}. Must be positive.}

\item{s}{\eqn{s=-1} for production and \eqn{s=1} for cost function.}

\item{lambda}{vector of \eqn{\lambda}. Must be positive.}

\item{nu}{vector defined as \eqn{\nu = \frac{1}{\lambda}}. Must be positive.}

\item{xi}{vector of location parameters of the skew-normal distribution defined as \eqn{\xi=\mu}}

\item{omega}{vector of scale parameters of the skew-normal distribution defined as \eqn{\omega=\sigma}. Must be positive.}

\item{alpha}{vector of slant parameters of the skew-normal distribution defined as \eqn{\alpha=s \lambda}.}

\item{delta}{vector of slant parameters rescaled \eqn{\frac{\alpha}{\sqrt{1+\alpha^2}}}. Must be within \eqn{(-1,1)}.}

\item{tau}{vector of the inverted scale parameters of the skew-normal distribution, e.g. \eqn{\tau = \frac{1}{\omega}}. Must be positive.}

\item{mean}{vector of mean of \eqn{\mathcal{E}}}

\item{sd}{vector of standard deviation of \eqn{\mathcal{E}}. Must be positive.}

\item{skew}{vector of skewness of \eqn{\mathcal{E}}.}

\item{par_u}{vector of \eqn{\sigma_U} or \eqn{\lambda}. Must be positive.}

\item{family}{\code{normhnorm} for normal-halfnormal and \code{normexp} for normal-exponential distribution.}
}
\value{
Returns a data.frame with the parameter values for all specification.
}
\description{
Transforms the given inputs to the parameters and the first three moments of the corresponding distribution. For the normal-halfnormal distribution the parametrization of the classical stochastic frontier as well as the skew-normal and centred skew-normal specification ar provided. For the normal-exponential an the specification via \eqn{\lambda} and \eqn{\nu} are available.
}
\details{
The following input combinations are allowed for the normal-halfnormal distribution
\itemize{
\item \code{mu}, \code{sigma_v}, \code{sigma_u}, \code{s}
\item \code{xi}, \code{omega}, \code{alpha}
\item \code{xi}, \code{tau}, \code{alpha}
\item \code{xi}, \code{omega}, \code{delta}
\item \code{xi}, \code{tau}, \code{delta}
\item \code{mean}, \code{sd}, \code{skew}, \code{family="normhnorm"}    \eqn{\qquad,}
} while for the normal-exponential distribution the feasible inputs are
\itemize{
\item \code{mu}, \code{sigma_v}, \code{lambda}, \code{s}
\item \code{mu}, \code{sigma_v}, \code{nu}, \code{s}
\item \code{mean}, \code{sd}, \code{skew}, \code{family="normexp"} \eqn{\qquad.}
} Other input combinations are not feasible.
}
\examples{
#Normal-halfnormal distribution
para<-reparametrize(mu=1, sigma_v=2, sigma_u=3,s=-1)
reparametrize(mean=para$mean, sd=para$sd, skew=para$skew, family="normhnorm")

#Normal-exponential distribution
para<-reparametrize(mu=1, sigma_v=2, lambda=1/3,s=-1)
reparametrize(mean=para$mean, sd=para$sd, skew=para$skew, family="normexp")

}
\references{
\itemize{
\item \insertRef{kumbhakar2015practitioner}{dsfa}
\item \insertRef{azzalini2013skew}{dsfa}
}
}
