% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DS.Analysis.R
\docType{class}
\name{DS.Analysis-class}
\alias{DS.Analysis-class}
\title{Class "DS.Analysis"}
\description{
Class \code{"DDF.Analysis"} is an S4 class describing a basic
 detection function model to be fitted to distance sampling data.
}
\section{Slots}{

\describe{
\item{\code{dfmodel}}{Object of class \code{"formula"}; describing the
detection function model.}

\item{\code{key}}{key function to use; "hn" gives half-normal (default), "hr"
gives hazard-rate and "unif" gives uniform. Note that if uniform key
is used, covariates cannot be included in the model.}

\item{\code{adjustment}}{a list containing adjustment parameters: adjustment -
either "cos" (recommended), "herm" or "poly", order - the orders of
the adjustment terms to fit, scale - the scale by which the distances
in the adjustment terms are divided. See details.}

\item{\code{truncation}}{Object of class \code{"list"}; Specifies
the truncation distance for the analyses.}

\item{\code{cutpoints}}{Object of class \code{"character"}; gives the
cutpoints of the bins for binned data analysis.}

\item{\code{er.var}}{specifies which encounter rate variance estimator to use.}

\item{\code{control.opts}}{A list to specify various options including
monotonicity, method, initial.values.}

\item{\code{group.strata}}{Dataframe with two columns ("design.id" and
"analysis.id"). The former gives the strata names as defined in the
design (i.e. the region object) the second specifies how they should
be grouped (into less strata) for the analyses}

\item{\code{criteria}}{Object of class \code{"character"}; describes
which model selection criteria to use ("AIC","AICc","BIC").}
}}

\section{Methods}{

\describe{
 \item{\code{run.analysis}}{\code{signature=c(object = "DS.Analysis",
 data = data.frame)}: runs the analysis described in the object on the
 data provided.}
}
}

\keyword{classes}
