% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dssimulation.R
\name{simattractors}
\alias{simattractors}
\title{Determine the attractors of a model through simulation}
\usage{
simattractors(discretize = NULL, xlim = NULL, ylim = NULL, stride = 8,
  iters = 1e+18, epsilon = NULL, tolerance = sqrt(.Machine$double.eps),
  cols = NULL)
}
\arguments{
\item{discretize}{The space between initial points. If not set, the discretization of the range
is used. May be set separately from the discretization of the range without overwriting.}

\item{xlim}{The range of x values to search for attractors. Defaults to the limits of the range.}

\item{ylim}{The range of y values to search for attractors. Defaults to the limits of the range.}

\item{stride}{The number of times the function is applied before movement is checked: in essence
finding the attractors for \code{f^stride}. For non-periodic dynamical systems, this is merely
an efficiency concern. For systems with periodic attractors with a period that is a factor of
that is a factor of \code{stride}, this may identify each of the points in the orbit. A warning
will be issued if a point is only stable in \code{f^stride}, and not in \code{f}. Default 8.}

\item{iters}{The maximum number of iterations to use. Points that still move greater than
\code{tolerance} will result in a warning and will be discarded. Can be disabled by setting to
\code{Inf} or 0. Default \code{1e+18}.}

\item{epsilon}{The distance at which two points are considered to be the same attractor. Defaults to \code{discretize^2}.}

\item{tolerance}{A, usually smaller, distance at which a point is considered to have stopped moving. Defaults to \code{sqrt(.Machine$double.eps)}.}

\item{cols}{The colors of the attractors. If insufficient not provided, reasonable defaults are used. Generally (but not always) proceeds left to right, then bottom to top.}
}
\description{
Attempts to determine the attractors of a model. The space is discretized into initial points, and
repeated iteration of the model's function is used to approximate the attractors. It is possible
that non-attractor fixpoints will be found by accident. The function
is iterated until the points move less than \code{tolerance} (default
\code{sqrt(.Machine$double.eps)}) between iterations.
The color of each point is drawn from the \code{col} parameter. If the number of points exceeds
the size of $\code{col}$, or $\code{col}$ is not defined, then reasonable defaults are used instead.
The attractors are \code{dspoint}s that are added to the model.
}
\examples{
model <- dsmodel(function(X0,Y0) {
list(X0*exp(2.6-X0-6.45/(1+4.5*X0)),
     Y0*exp(2.6-Y0-0.15*X0-6.25/(1+4.5*Y0)))
})

model + dsrange(5,5,0.09) + simattractors(discretize=0.02)
}
\seealso{
\code{\link{dspoint}}

\code{\link{dsregion}}

\code{\link{dspolygon}}

\code{\link{simbasins}}
}
