% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/belplauH.R
\name{belplauH}
\alias{belplauH}
\title{Calculate belief, disbelief, unknown, plausibility, plausibility ratio}
\usage{
belplauH(MACC, W2, h)
}
\arguments{
\item{MACC}{Vector of masses e.g. x$spec[,2]}

\item{W2}{Description matrix e.g. x$tt}

\item{h}{H
hypotheses to be tested, same format as x$tt}
}
\value{
A matrix of \code{M} rows by 5 columns is returned, where \code{M} is the number of hypothesis tested: \itemize{
 \item Column 1: the degree of Belief \code{bel};
 \item Column 2: the degree of Disbellief (belief in favor of the contrary hypothesis) \code{disbel};
 \item Column 3: the degree of Epistemic uncertainty \code{unc};
 \item Column 4: the degree of Plausibility \code{plau};
 \item Column 5: the Plausibility ratio \code{rplau}.
   }
}
\description{
Calculate belief, disbelief, unknown, plausibility, plausibility ratio
}
\examples{
x <- bca(tt = matrix(c(1,1,0,1,1,1), nrow = 2, byrow = TRUE), m = c(0.8, 0.2), cnames = c(1,2,3))
belplauH(MACC = x$spec[,2], W2 = x$tt, h = x$tt)
hyp <- matrix(c(0,1,0, 0,1,1), nrow = 2, byrow = TRUE)
rownames(hyp) <- nameRows(hyp)
belplauH(MACC = x$spec[,2], W2 = x$tt, h = hyp)
}
\author{
Peiyuan Zhu
}
