% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applied_crm.R
\name{plot_crm}
\alias{plot_crm}
\title{Plot of posterior estimates from the CRM}
\usage{
plot_crm(crm, dose_labels, cohort_sizes = NULL, file = NULL,
                height = 600, width = 750, dose_func = NULL, ...,
                ylim = c(0, 1), lwd = 1, cex.axis = 1, cex.lab = 1,
                cex = 1, cohort.last = F)
}
\arguments{
\item{crm}{An object of class 'mtd' produced by applied_crm to be plotted.}

\item{dose_labels}{A vector of character strings detailing the labels to be
used for each dose level in the plot.}

\item{cohort_sizes}{An optional vector of cohort sizes; if provided the
previous estimates for each cohort will be plotted in addition.}

\item{file}{An optional string for the file name; if provided the plot will
be saved as a .PNG to the current working directory under the provided
file name.}

\item{height}{A numeric value specifying the vertical pixel count of the
plot. Default is 600.}

\item{width}{A numeric value specifiying the horizontal pixel count of the
plot. Default is 750.}

\item{dose_func}{Must be provided if cohort_sizes is provided. The function
to be used to when implementing the CRM for previous cohorts.}

\item{...}{Arguments to be provided to dose_func detailing CRM specification.
See applied_crm.}

\item{ylim}{The y-axis range. Default is c(0, 1)}

\item{lwd}{line width relative to the default (default=1). 2 is twice as wide. Default is 1.}

\item{cex.axis}{The magnification to be used for axis annotation relative to the current setting of cex. Default is 1.}

\item{cex.lab}{The magnification to be used for x and y labels relative to the current setting of cex. Default is 1.}

\item{cex}{A numerical value giving the amount by which plotting text and symbols should be magnified relative to the default. Default is 1.}

\item{cohort.last}{If TRUE, the last cohort will have lwd = 6 for emphasis. Default is FALSE.}
}
\description{
Provides functionality for plotting the posterior estimates of
    probabilities of toxicity at each dose level for both the most recent
    update and for past cohort updates if specified.
}
\details{
Produces a plot of current dose-toxicity estimates including the
    priors and outputs a .png of plot to current directory if 'file' is
    provided. Potential for history of estimates by cohort if cohort.sizes is
    provided; dose_func is required to do this.
}
\examples{
prior  <- c(0.1, 0.3, 0.5)
target <- 0.2
tox    <- c(0, 0, 1, 0, 1, 1)
level  <- c(1, 1, 1, 2, 2, 2)

crm <- applied_crm(prior, target, tox, level, no_skip_esc = TRUE, no_skip_deesc = TRUE,
                   global_coherent_esc = TRUE, stop_func = NULL)

plot_crm(crm, dose_labels = c("1", "2", "3"))

}
\keyword{CRM}
\keyword{dtpcrm}
\keyword{plot}
