% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopping_delegates.R
\name{stop_for_excess_toxicity_empiric}
\alias{stop_for_excess_toxicity_empiric}
\title{Stopping for excess toxicity - Empiric method}
\usage{
stop_for_excess_toxicity_empiric(x, tox_lim, prob_cert, dose = 1,
    nsamps = 10^6, suppress_dose = TRUE)
}
\arguments{
\item{x}{An object of class 'mtd'.}

\item{tox_lim}{A numeric; specifying the value for which the estimated
toxicity at the selcted dose is not to exceed.}

\item{prob_cert}{A numeric; specifying the probability value to be used when
assessing the certainty required that toxicty at the specificed dose
exceeds tox_lim.}

\item{dose}{An integer; the dose to be assessed.}

\item{nsamps}{number of samples used for beta in the underlying normal
sampling of beta.}

\item{suppress_dose}{A logical value indicating if the MTD should be set to
NA if trial should stop.}
}
\description{
This is a function for use with applied_crm for the stop_func
    argument. The rule will suggest stopping in the scenario that the
    probability of toxicity being greater than a specifed value at a defined
    dose is greater than some further specified certainty value.
}
\details{
This function is an example of a possible stopping function to be
    used with applied_crm, it will modifiy the 'mtd' class object produced by
    applied_crm to include a logical value under the name 'stop' indicating
    whether or not the trial should stop. The package dtpcrm contains a few
    of these functions for possible use with applied_crm.
}
\examples{
prior  <- c(0.1, 0.3, 0.5)
target <- 0.2
tox    <- c(0, 0, 1, 0, 1, 1)
level  <- c(1, 1, 1, 2, 2, 2)

stop_rule <- function(x){
  x <- stop_for_excess_toxicity_empiric(x, tox_lim = 0.25, prob_cert = 0.85)
}

crm <- applied_crm(prior, target, tox, level, no_skip_esc = TRUE, no_skip_deesc = TRUE,
                   global_coherent_esc = TRUE, stop_func = stop_rule)

}
\keyword{CRM}
\keyword{dtpcrm}
\keyword{stop}
