% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{group_modify.trackr_df}
\alias{group_modify.trackr_df}
\title{Group-wise modification of data and complex operations}
\usage{
\method{group_modify}{trackr_df}(
  .data,
  .f,
  ...,
  .keep = FALSE,
  .messages = NULL,
  .headline = .defaultHeadline(),
  .type = "modify",
  .tag = NULL
)
}
\arguments{
\item{.data}{\itemize{
\item a dataframe which may be grouped
}}

\item{.f}{a function as expected by dplyr::group_modify e.g. function(d,g,...) { ...do something with d and return a dataframe... }}

\item{...}{additional parameters for .f.}

\item{.keep}{\itemize{
\item are the grouping variables kept in d, or split out to g (the default)
}}

\item{.messages}{\itemize{
\item a set of glue specs. The glue code can use any global variable, or \{.strata\},\{.count.in\},and \{.count.out\}
}}

\item{.headline}{\itemize{
\item a headline glue spec. The glue code can use any global variable, or \{.strata\},\{.count.in\},and \{.count.out\}
}}

\item{.type}{\itemize{
\item default "modify": used to define formatting
}}

\item{.tag}{\itemize{
\item if you want the summary data from this step in the future then give it a name with .tag.
}}
}
\value{
the transformed .data dataframe with the history graph updated.
}
\description{
Group modifying a data set acts in the normal way. The internal mechanics of the modify function are opaque to the history.
This means these can be used to wrap any unsupported operation without losing the history (e.g. \code{df \%>\% track() \%>\% group_modify(function(d,...) { d \%>\% unsupported_operation() })} )
Prior to the operation the size of the group is calculated \{.count.in\} and
after the operation the output size \{.count.out\}
The group \{.strata\} is also available (if grouped) for reporting
See \code{\link[dplyr:group_map]{dplyr::group_modify()}}.
}
\examples{
library(dplyr)
tmp = iris \%>\% track() \%>\% group_by(Species)
tmp \%>\% group_modify(
      function(d,g,...) { return(tibble::tibble(x=runif(10))) },
      .messages="{.count.in} in, {.count.out} out"
) \%>\% history()
}
\seealso{
dplyr::group_modify()
}
