% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twdtwClassify.R
\docType{methods}
\name{twdtwClassify}
\alias{twdtwClassify}
\alias{twdtwClassify,twdtwMatches-method}
\alias{twdtwClassify,twdtwRaster-method}
\alias{twdtwClassify-twdtwRaster}
\alias{twdtwClassify-twdtwTimeSeries}
\title{Classify time series}
\usage{
twdtwClassify(x, ...)

\S4method{twdtwClassify}{twdtwMatches}(x, patterns.labels = NULL,
  from = NULL, to = NULL, by = NULL, breaks = NULL, overlap = 0.5,
  thresholds = Inf, fill = "unclassified")

\S4method{twdtwClassify}{twdtwRaster}(x, patterns.labels = NULL,
  thresholds = Inf, fill = 255, filepath, ...)
}
\arguments{
\item{x}{an object of class twdtw*. This is the target time series. 
Usually, it is a set of unclassified time series.}

\item{...}{arguments to pass to specifique methods for each twdtw* signature 
and other arguments to pass to \code{\link[raster]{writeRaster}}.}

\item{patterns.labels}{a vector with labels of the patterns.}

\item{from}{A character or \code{\link[base]{Dates}} object in the format "yyyy-mm-dd".}

\item{to}{A \code{\link[base]{character}} or \code{\link[base]{Dates}} object in the format "yyyy-mm-dd".}

\item{by}{A \code{\link[base]{character}} with the intevals size, \emph{e.g.} "6 month".}

\item{breaks}{A vector of class \code{\link[base]{Dates}}. This replaces the arguments \code{from},
\code{to}, and \code{by}.}

\item{overlap}{A number between 0 and 1. The minimum overlapping 
between one match and the interval of classification. Default is 0.5, 
\emph{i.e.} an overlap minimum of 50\%.}

\item{thresholds}{A numeric vector the same length as \code{patterns.labels}. 
The TWDTW dissimilarity thresholds, i.e. the maximum TWDTW cost for consideration 
in the classification. Default is \code{Inf} for all \code{patterns.labels}.}

\item{fill}{a character or value to fill the classification gaps. 
For signature \code{twdtwTimeSeries} the default is \code{fill="unclassified"}, and 
for signature \code{twdtwRaster} the default is \code{fill="unclassified"}.}

\item{filepath}{A character. The path to save the raster with results. If not informed the 
function saves in the same directory as the input time series raster.}
}
\value{
An object of class twdtw*.
}
\description{
This function classifies the intervals of a time series 
based on the TWDTW results.
}
\examples{
# Classifying time series based on TWDTW results 
ts = twdtwTimeSeries(example_ts.list)
patt = twdtwTimeSeries(patterns.list)
log_fun = logisticWeight(-0.1, 100)
time_intervals = seq(from=as.Date("2007-09-01"), to=as.Date("2013-09-01"), by="6 month")
mat = twdtwApply(x=ts, y=patt, weight.fun=log_fun, keep=TRUE)
best_mat = twdtwClassify(x=mat, breaks=time_intervals, overlap=0.5)
plot(x=best_mat, type="classification")

\dontrun{
require(parallel)
best_mat = mclapply(as.list(mat), mc.cores=4, FUN=twdtwClassify, breaks=time_intervals, overlap=0.5)
best_mat = twdtwMatches(alignments=best_mat)
}
\dontrun{
# Run TWDTW analysis for raster time series 
load(system.file("lucc_MT/temporal_patterns.RData", package="dtwSat"))
patt = twdtwTimeSeries(temporal_patterns)
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
red = brick(system.file("lucc_MT/data/red.tif", package="dtwSat"))
blue = brick(system.file("lucc_MT/data/blue.tif", package="dtwSat"))
nir = brick(system.file("lucc_MT/data/nir.tif", package="dtwSat"))
mir = brick(system.file("lucc_MT/data/mir.tif", package="dtwSat"))
doy = brick(system.file("lucc_MT/data/doy.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = twdtwRaster(evi, ndvi, red, blue, nir, mir, timeline = timeline, doy = doy)

time_interval = seq(from=as.Date("2007-09-01"), to=as.Date("2013-09-01"), 
                    by="12 month")
log_fun = weight.fun=logisticWeight(-0.1,50)

r_twdtw = twdtwApply(x=rts, y=patt, weight.fun=log_fun, breaks=time_interval, 
          filepath="~/test_twdtw", overwrite=TRUE, format="GTiff", mc.cores=3)

r_lucc = twdtwClassify(r_twdtw, format="GTiff")

}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtwApply}}, 
\code{\link[dtwSat]{twdtwMatches-class}}, 
\code{\link[dtwSat]{twdtwTimeSeries-class}}, and 
\code{\link[dtwSat]{twdtwRaster-class}},
}

