# Generated by 02-duckplyr_df-methods.R
#' @export
semi_join.duckplyr_df <- function(x, y, by = NULL, copy = FALSE, ..., na_matches = c("na", "never")) {
  check_dots_empty0(...)
  error_call <- caller_env()
  y <- auto_copy(x, y, copy = copy)

  # https://github.com/duckdb/duckdb/issues/6597
  na_matches <- check_na_matches(na_matches, error_call = error_call)

  # Our implementation
  rel_try(call = list(name = "semi_join", x = x, y = y, args = list(by = if(!is.null(by)) as_join_by(by), copy = copy, na_matches = na_matches)),
    {
      out <- rel_join_impl(x, y, by, "semi", na_matches, error_call = error_call)
      return(out)
    }
  )

  # dplyr forward
  semi_join <- dplyr$semi_join.data.frame
  out <- semi_join(x, y, by, copy = FALSE, ..., na_matches = na_matches)
  return(out)

  # dplyr implementation
  check_dots_empty0(...)
  y <- auto_copy(x, y, copy = copy)
  join_filter(x, y, by = by, type = "semi", na_matches = na_matches, user_env = caller_env())
}

duckplyr_semi_join <- function(x, y, ...) {
  try_fetch(
    {
      x <- as_duckplyr_df(x)
      y <- as_duckplyr_df(y)
    },
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- semi_join(x, y, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
