# Generated by 02-duckplyr_df-methods.R
#' @export
groups.duckplyr_df <- function(x) {
  # Our implementation
  duckplyr_error <- rel_try(NULL,
    # Always fall back to dplyr
    "No relational implementation for {.code groups()}" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  check_prudence(x, duckplyr_error)

  groups <- dplyr$groups.data.frame
  out <- groups(x)
  return(out)

  # dplyr implementation
  syms(group_vars(x))
}

duckplyr_groups <- function(x, ...) {
  try_fetch(
    x <- as_duckplyr_df_impl(x),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- groups(x, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
