% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle_lnorm_lnorm.R
\name{mle_lnorm_lnorm}
\alias{mle_lnorm_lnorm}
\title{Maximum Likelihood Estimation for X[1], ..., X[n] ~ Lognormal(mu1, sigsq1) 
Lognormal(mu2, sigsq2)}
\usage{
mle_lnorm_lnorm(x, mu2 = NULL, sigsq2 = NULL, estimate_var = FALSE,
  ...)
}
\arguments{
\item{x}{Numeric vector.}

\item{mu2}{Numeric value specifying known mu2.}

\item{sigsq2}{Numeric value specifying known sigsq2.}

\item{estimate_var}{Logical value for whether to return Hessian-based
variance-covariance matrix.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Each observation is assumed to be the product of a Lognormal(mu1, sigsq1) and 
Lognormal(mu2, sigsq2) random variable, with mu2 and sigsq2 known. Performs 
maximization via \code{\link[stats]{nlminb}}. mu and sigsq correspond to 
meanlog and sdlog^2 in \code{\link[stats]{Lognormal}}.
}
\examples{
# Generate 1,000 values from Lognormal(0.5, 1) x Lognormal(0.75, 1.5) and 
# estimate parameters based on known mu and sigsq for one of them
set.seed(123)
x <- rlnorm(1000, 0.5, sqrt(1)) * rlnorm(1000, 0.75, sqrt(1.5))
mle_lnorm_lnorm(x, mu2 = 0.75, sigsq2 = 1.5)


}
