% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_validate.R
\name{dct_validate}
\alias{dct_validate}
\title{Validate a taxonomic database}
\usage{
dct_validate(
  tax_dat,
  check_taxon_id = dct_options()$check_taxon_id,
  check_tax_status = dct_options()$check_tax_status,
  check_mapping_accepted = dct_options()$check_mapping_accepted,
  check_mapping_parent = dct_options()$check_mapping_parent,
  check_mapping_original = dct_options()$check_mapping_original,
  check_mapping_accepted_status = dct_options()$check_mapping_accepted_status,
  check_sci_name = dct_options()$check_sci_name,
  check_status_diff = dct_options()$check_status_diff,
  check_col_names = dct_options()$check_col_names,
  valid_tax_status = dct_options()$valid_tax_status,
  extra_cols = dct_options()$extra_cols,
  on_success = dct_options()$on_success,
  on_fail = dct_options()$on_fail,
  skip_missing_cols = dct_options()$skip_missing_cols,
  quiet = dct_options()$quiet
)
}
\arguments{
\item{tax_dat}{Dataframe; taxonomic database in DwC format.}

\item{check_taxon_id}{Logical vector of length 1; should all instances of  \code{taxonID} be required to be non-missing and unique? Default \code{TRUE}.}

\item{check_tax_status}{Logical vector of length 1; should all taxonomic names be required to have a valid value for taxonomic status (by default, "accepted", "synonym", or "variant")? Default \code{TRUE}.}

\item{check_mapping_accepted}{Logical vector of length 1; should all values of \code{acceptedNameUsageID} be required to map to the \code{taxonID} of an existing name? Default \code{TRUE}.}

\item{check_mapping_parent}{Logical vector of length 1; should all values of \code{parentNameUsageID} be required to map to the \code{taxonID} of an existing name? Default \code{TRUE}.}

\item{check_mapping_original}{Logical vector of length 1; should all values of \code{originalNameUsageID} be required to map to the \code{taxonID} of an existing name? Default \code{TRUE}.}

\item{check_mapping_accepted_status}{Logical vector of length 1; should rules about mapping of variants and synonyms be enforced? Default \code{FALSE}.
(see Details).}

\item{check_sci_name}{Logical vector of length 1; should all instances of \code{scientificName} be required to be non-missing and unique? Default \code{TRUE}.}

\item{check_status_diff}{Logical vector of length 1; should each scientific name be allowed to have only one taxonomic status? Default \code{FALSE}.}

\item{check_col_names}{Logical vector of length 1; should all column names be required to be a valid Darwin Core term? Default \code{TRUE}.}

\item{valid_tax_status}{Character vector of length 1; valid values for \code{taxonomicStatus}. Each value must be separated by a comma. Default \verb{accepted, synonym, variant, NA}. \code{"NA"} indicates that missing (NA) values are valid. Case-sensitive.}

\item{extra_cols}{Character vector; names of columns that should be allowed beyond
those defined by the Darwin Core DwC taxon standard. Default NULL. Providing column name(s) that are valid DwC taxon column(s) has no effect.}

\item{on_success}{Character vector of length 1, either "logical" or "data". Describes what to do if the check passes. Default \code{"data"}.}

\item{on_fail}{Character vector of length 1, either "error" or "summary". Describes what to do if the check fails. Default \code{"error"}.}

\item{skip_missing_cols}{Logical vector of length 1; should checks be silently skipped if any of the
columns they inspect are missing? Default \code{FALSE}.}

\item{quiet}{Logical vector of length 1; should warnings be silenced? Default \code{FALSE}.}
}
\value{
Depends on the result of the check and on values of \code{on_fail} and
\code{on_success}:
\itemize{
\item If the check passes and \code{on_success} is "logical", return \code{TRUE}
\item If the check passes and \code{on_success} is "data", return the input dataframe
\item If the check fails and \code{on_fail} is "error", return an error
\item If the check fails and \code{on_fail} is "summary", issue a warning and
return a dataframe with a summary of the reasons for failure
}
}
\description{
Runs a series of automated checks on a taxonomic database in Darwin Core
(DwC) format.
}
\details{
For \code{check_mapping_accepted_status} and \code{check_status_diff}, "accepted",
"synonym", and "variant" are determined by string matching of
\code{taxonomicStatus}; so "provisionally accepted" is counted as "accepted",
"ambiguous synonym" is counted as "synonym", etc. (case-sensitive).

For \code{check_mapping_accepted_status}, the following rules are enforced:
\itemize{
\item Rows with \code{taxonomicStatus} of "synonym" (synonyms) must have an
\code{acceptedNameUsageID} matching the \code{taxonID} of an accepted name
(\code{taxonomicStatus} of "accepted")
\item Rows with \code{taxonomicStatus} of "variant" (orthographic variants) must
have an \code{acceptedNameUsageID} matching the \code{taxonID} of an accepted name or
synonym (but not another variant)
\item Rows with \code{taxonomicStatus} of "accepted" must not have any value entered
for \code{acceptedNameUsageID}
\item Rows with a value for \code{acceptedNameUsageID} must have a valid value for
\code{taxonomicStatus}.
}

Default settings of all arguments can be modified with \code{dct_options()} (see
Examples).

Most columns are expected to be vectors of class character, but this is not
checked for all columns. Columns (DwC terms) with names including 'ID', for
example 'taxonID', may be character, numeric, or integer.
}
\examples{
# The example dataset dct_filmies is already correctly formatted and passes
# validation
dct_validate(dct_filmies)

# So make some bad data on purpose with a duplicated scientific name
bad_dat <- dct_filmies
bad_dat$scientificName[1] <- bad_dat$scientificName[2]

# The incorrectly formatted data won't pass (example produces an error, so
# not run by default)
\dontrun{
dct_validate(bad_dat)
}

# It will pass if we allow duplicated scientific names though
dct_validate(bad_dat, check_sci_name = FALSE)

# Individual checks can also be turned or off with dct_options()

# First save the current settings before making any changes
old_settings <- dct_options()

# Let's allow duplicated scientific names by default
dct_options(check_sci_name = FALSE)

# The data passes validation as before, but we don't have to specify
# `check_sci_name = FALSE` in the function call
dct_validate(bad_dat)

# Reset options to those before this example was run
do.call(dct_options, old_settings)

}
