% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Extract-simulation.R
\name{ext_output}
\alias{ext_output}
\title{Extract outputs from a DYRESM-CAEDYM model run}
\usage{
ext_output(dycd.output, var.extract, verbose = FALSE)
}
\arguments{
\item{dycd.output}{a string of characters describing the file path to
the output netcdf file of DYRESM-CAEDYM model.}

\item{var.extract}{a vector of variables to be extracted from the output.
Please refer to the var.name of data(output_name) for accepted variable name.
Apart from the user nominated variables, simulation period and
layer height data are also extracted.}

\item{verbose}{if TRUE, the information about the extraction
process is printed.}
}
\value{
a list of values of those variables of interest,
   as well as two compulsory variables (i.e. simulation period, layer height)
}
\description{
Extract simulation outputs from a DYRESM-CAEDYM  model run.
}
\examples{
 # extract simulated temperature values from DYRESM-CAEDYM simulation file
 var.values<-ext_output(dycd.output=system.file("extdata", "dysim.nc",
                                                 package = "dycdtools"),
                       var.extract=c("TEMP"))

 for(i in 1:length(var.values)){
  expres<-paste0(names(var.values)[i],"<-data.frame(var.values[[",i,"]])")
  eval(parse(text=expres))
 }

}
