% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.R
\name{residuals.ddhazard}
\alias{residuals.ddhazard}
\title{Residuals Method for ddhazard Object}
\usage{
\method{residuals}{ddhazard}(
  object,
  type = c("std_space_error", "space_error", "pearson", "raw"),
  data = NULL,
  ...
)
}
\arguments{
\item{object}{result of \code{\link{ddhazard}} call.}

\item{type}{type of residuals. Four possible values: \code{"std_space_error"}, \code{"space_error"}, \code{"pearson"} and \code{"raw"}. See the sections below for details.}

\item{data}{\code{data.frame} with data for the Pearson or raw residuals. This is only needed if the data set is not saved with the \code{object}. Must be the same data set used in the initial call to \code{\link{ddhazard}}.}

\item{...}{not used.}
}
\description{
Residuals method for the result of a \code{\link{ddhazard}} call.
}
\section{Pearson and raw residuals}{

Is the result of a call with a \code{type} argument of either \code{"pearson"} or \code{"raw"} for Pearson residuals or raw residuals. Returns a list with class \code{"ddhazard_residual"} with the following elements.
\describe{
\item{\code{residuals}}{list of residuals for each bin. Each element of the list contains a 2D array where the rows corresponds to the passed \code{data} and columns are the residuals (\code{residuals}), estimated probability of death (\code{p_est}), outcome (\code{Y}) and row number in the initial data set (\code{row_num}). The \code{data} rows will only have a residuals in a given risk list if they are at risk in that risk set.}
\item{\code{type}}{the type of residual.}
}
}

\section{State space errors}{

Is the result of a call with a \code{type} argument of either \code{"std_space_error"} or \code{"space_error"}. The former is for standardized residuals while the latter is non-standardized. Returns a list with class. \code{"ddhazard_space_errors"} with the following elements:
\describe{
\item{\code{residuals}}{2D array with either standardized or non-standardized state space errors. The row are bins and the columns are the parameters in the regression.}
\item{\code{standardize}}{\code{TRUE} if standardized state space errors.}
\item{\code{Covariances}}{3D array with the smoothed co-variance matrix for each set of the state space errors.}
}
}

\examples{
library(dynamichazard)
fit <- ddhazard(
 Surv(time, status == 2) ~ log(bili), pbc, id = pbc$id, max_T = 3600,
 Q_0 = diag(1, 2), Q = diag(1e-4, 2), by = 50,
 control = ddhazard_control(method = "GMA"))
resids <- residuals(fit, type = "pearson")$residuals
head(resids[[1]])
head(resids[[2]])

}
