% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evap.R
\name{evap_est}
\alias{evap_est}
\title{Create sinusoidal time series of potential evapotranspiration input}
\usage{
evap_est(ts, eMin = 0, eMax = 0)
}
\arguments{
\item{ts}{as vector of POSIXct data/times}

\item{eMin}{Minimum daily PE total (m or mm)}

\item{eMax}{Maximum daily PE total (m or mm)}
}
\value{
Time series (xts) of potential evapotranspiration totals for the time steps given in same units as eMin and eMax
}
\description{
Generate series of potential evapotranspiration
}
\details{
Dynamic TOPMODEL requires a time series of potential
  evapotranspiration in order to calculate and remove actual
  evapotranspiration from the root zone during a run. Many sophisticated
  physical models have been developed for estimating potential and actual evapotranspiration, including the
  Priestly-Taylor (Priestley and Taylor, 1972) and Penman-Monteith (Montieth,
  1965) methods. These, however, require detailed meteorological data such as
  radiation input and relative humidities that are, in general, difficult to
  obtain. Calder (1983) demonstrated that a simple approximation using a
  sinusoidal variation in potential evapotranspiration to be a good
  approximation to more complex schemes.

  If the insolation is also taken to vary sinusoidally through the daylight
  hours then, ignoring diurnal meteorological variations, the potential
  evapotranspiration during daylight hours for each year day number can be
  calculated (for the catchment's latitude). Integration over the daylight
  hours allows the daily maximum to be calculated and thus a sub-daily series
  generated.
}
\examples{
## Generating daily PET data for 1970
## the values of eMin and eMax may not by not be realistic
st <- as.POSIXct("1970-01-02 00:00:00",tz='GMT')
fn <- as.POSIXct("1971-01-01 00:00:00",tz='GMT')
daily_ts <- seq(st,fn,by=24*60*60)
dpet <- evap_est(daily_ts,0,1)

## create hourly data for the same period
st <- as.POSIXct("1970-01-01 01:00:00",tz='GMT')
fn <- as.POSIXct("1971-01-01 00:00:00",tz='GMT')
hour_ts <- seq(st,fn,by=1*60*60)
hpet <- evap_est(hour_ts,0,1)

## the totals should eb the same...
stopifnot(all.equal(sum(hpet), sum(dpet)))
}
\references{
Beven, K. J. (2012). Rainfall-runoff modelling : the primer. Chichester, UK, Wiley-Blackwell.

Calder, I. R. (1986). A stochastic model of rainfall interception. Journal of Hydrology, 89(1), 65-71.
}
