% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_initialisation.R
\name{initialise_model}
\alias{initialise_model}
\title{Initial settings for simulating a dyngen dataset}
\usage{
initialise_model(
  backbone,
  num_cells = 1000,
  num_tfs = nrow(backbone$module_info),
  num_targets = 100,
  num_hks = 50,
  distance_metric = c("pearson", "spearman", "cosine", "euclidean", "manhattan"),
  tf_network_params = tf_network_default(),
  feature_network_params = feature_network_default(),
  kinetics_params = kinetics_default(),
  gold_standard_params = gold_standard_default(),
  simulation_params = simulation_default(),
  experiment_params = experiment_snapshot(),
  verbose = TRUE,
  download_cache_dir = getOption("dyngen_download_cache_dir"),
  num_cores = getOption("Ncpus") \%||\% 1L,
  id = NULL
)
}
\arguments{
\item{backbone}{The gene module configuration that determines the type of dynamic
process being simulated. See \code{\link[=list_backbones]{list_backbones()}} for a full list of different backbones
available in this package.}

\item{num_cells}{The number of cells to sample.}

\item{num_tfs}{The number of transcription factors (TFs) to generate. TFs are the
main drivers of the changes that occur in a cell. TFs are regulated only by other
TFs.}

\item{num_targets}{The number of target genes to generate. Target genes are
regulated by TFs and sometimes by other target genes.}

\item{num_hks}{The number of housekeeping genes (HKs) to generate. HKs are
typically highly expressed, and are not regulated by the TFs or targets.}

\item{distance_metric}{The distance metric to be used to calculate the distance
between cells. See \code{\link[dynutils:calculate_distance]{dynutils::calculate_distance()}} for a list of possible
distance metrics.}

\item{tf_network_params}{Settings for generating the TF network with
\code{\link[=generate_tf_network]{generate_tf_network()}}, see \code{\link[=tf_network_default]{tf_network_default()}}.}

\item{feature_network_params}{Settings for generating the feature network with
\code{\link[=generate_feature_network]{generate_feature_network()}}, see \code{\link[=feature_network_default]{feature_network_default()}}.}

\item{kinetics_params}{Settings for determining the kinetics of the feature network
with \code{\link[=generate_kinetics]{generate_kinetics()}}, see \code{\link[=kinetics_default]{kinetics_default()}}.}

\item{gold_standard_params}{Settings pertaining simulating the gold standard with
\code{\link[=generate_gold_standard]{generate_gold_standard()}}, see \code{\link[=gold_standard_default]{gold_standard_default()}}.}

\item{simulation_params}{Settings pertaining the simulation itself with \code{\link[=generate_cells]{generate_cells()}},
see \code{\link[=simulation_default]{simulation_default()}}.}

\item{experiment_params}{Settings related to how the experiment is simulated with
\code{\link[=generate_experiment]{generate_experiment()}}, see \code{\link[=experiment_snapshot]{experiment_snapshot()}} or \code{\link[=experiment_synchronised]{experiment_synchronised()}}.}

\item{verbose}{Whether or not to print messages during the simulation.}

\item{download_cache_dir}{If not \code{NULL}, temporary downloaded files will be
cached in this directory.}

\item{num_cores}{Parallellisation parameter for various steps in the pipeline.}

\item{id}{An identifier for the model.}
}
\value{
A dyngen model.
}
\description{
Initial settings for simulating a dyngen dataset
}
\examples{
model <- initialise_model(
  backbone = backbone_bifurcating(),
  num_cells = 555,
  verbose = FALSE,
  download_cache_dir = "~/.cache/dyngen"
)
}
\seealso{
\link{dyngen} on how to run a complete dyngen simulation
}
