\name{Ovarian cancer data}

\docType{data}

\alias{ova}

\title{Data originate from two clinical trials on the use of different combination
chemotherapies, carried out in The Netherlands around 1980}

\description{A data frame of 358 patients with ovarian cancer.
The included variables are
  \describe{
  \item{tyears}{Time in years until death or last follow-up}
  \item{d}{Survival status; 1 = death; 0 = censored}
  \item{Karn}{Karnofsky score}
  \item{Broders}{Broders score: factor with levels "unknown", "1", "2", "3", "4"}
  \item{FIGO}{FIGO stage; factor with levels "III", "IV"}
  \item{Ascites}{Presence of ascires; factor with levels "unknown", "absent", "present"}
  \item{Diam}{Diameter of the tumor; factor with levels "micr.", "<1cm", "1-2cm", "2-5cm", ">5cm"}
  }
}

\usage{data(ova)}

\format{A data frame, see \code{\link{data.frame}}.}

\references{
Neijt, J. P., ten Bokkel Huinink, W. W., van der Burg, M. E., van Oosterom,
A. T., Vriesendorp, R., Kooyman, C. D., van Lindert, A. C., Hamerlynck,
J. V., van Lent, M. & van Houwelingen, J. C. (1984), `Randomised trial
comparing two combination chemotherapy regimens (Hexa-CAF vs CHAP-
5) in advanced ovarian carcinoma', Lancet 2, 594--600.

Neijt, J. P., ten Bokkel Huinink, W. W., van der Burg, M. E., van Oosterom,
A. T., Willemse, P. H., Heintz, A. P., van Lent, M., Trimbos, J. B., Bouma,
J. & Vermorken, J. B. (1987), `Randomized trial comparing two combination
chemotherapy regimens (CHAP-5 vs CP) in advanced ovarian carcinoma',
Journal of Clinical Oncology 5, 1157--1168.

van Houwelingen, J. C., ten Bokkel Huinink, W. W., van der Burg, M. E.,
van Oosterom, A. T. & Neijt, J. P. (1989), `Predictability of the survival
of patients with advanced ovarian cancer.', Journal of Clinical Oncology
7, 769--773.
}

\keyword{datasets}