% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jointSummarize.R
\name{jointSummarize}
\alias{jointSummarize}
\title{Summarize posterior distributions of model parameters.}
\usage{
jointSummarize(modelfit, par = "all", probs = c(0.025, 0.975), digits = 3)
}
\arguments{
\item{modelfit}{An object of class \code{stanfit}.}

\item{par}{A character vector of parameter names. The default is 'all'.}

\item{probs}{A numeric vector of quantiles of interest. The default is
c(0.025,0.975).}

\item{digits}{An integer indicating the number of decimal
places to round values in summary table. Default value is 3.}
}
\value{
A summary table of parameter estimates.
}
\description{
This function summarizes the posterior distributions of specified parameters
from a model fit. Summary includes mean, sd, and specified quantiles, as
well as effective sample size (n_eff) and Rhat for estimated parameters. See
more examples in the
\href{https://bookdown.org/abigailkeller/eDNAjoint_vignette/}{Package
Vignette}.
}
\note{
Before fitting the model, this function checks to ensure that the
function is possible given the inputs. These checks include:
\itemize{
\item  Input model fit is an object of class 'stanfit'.
\item  Input probs is a numeric vector.
\item  Input par is a character vector.
\item  Input par are present in fitted model.
\item  Input model fit has converged (i.e. no divergent transitions after
warm-up).
}

If any of these checks fail, the function returns an error message.
}
\examples{
\donttest{
data(greencrabData)

# Fit a model
modelfit <- jointModel(data = greencrabData, family = "negbin", q = TRUE,
                       multicore = FALSE)

# Create summary table of all parameters
jointSummarize(modelfit$model)

# Summarize just 'p10' parameter
jointSummarize(modelfit$model, par = "p10", probs = c(0.025, 0.975),
               digits = 3)
}

}
