% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgm_plot_class.R
\name{HDI}
\alias{HDI}
\alias{plot_parameterHDI}
\title{Plot of interaction parameters and their 95\% highest density intervals}
\usage{
plot_parameterHDI(output, ...)
}
\arguments{
\item{output}{Output object from the easybgm function. Supports also objects from the bgm function of the \code{bgms} package.}

\item{...}{Additional arguments passed onto \code{ggplot2}}
}
\value{
Returns a plot
}
\description{
Plots the 95\% highest density interval of the posterior distribution of the parameter estimates. The plot can be used to visualize the uncertainty of the partial association estimates. The x-axis indicates the strength of the partial association. The y-axis indicates the edge between nodes $i$ and $j$. The farther the posterior estimates (i.e., the points in the plot) are from zero, the stronger the partial association of the edge. The wider the highest density intervals (i.e., the error bar around the point), the less certain we are about the strength of the association.
}
\examples{
\donttest{

library(easybgm)
library(bgms)


data <- na.omit(Wenchuan)
fit <- easybgm(data, type = "ordinal",
              iter = 1000,  # for demonstration only (> 5e4 recommended)
              save = TRUE)
plot_parameterHDI(fit)
}
}
