% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRFEAT.R
\name{plotRFEAT}
\alias{plotRFEAT}
\title{Random Forest + Efficiency Analysis Trees Plot}
\usage{
plotRFEAT(object)
}
\arguments{
\item{object}{A \code{RFEAT} object.}
}
\value{
Line plot with the OOB error and the number of trees in the forest.
}
\description{
Plot a graph with the Out-of-Bag error for a forest consisting of m trees.
}
\examples{
\donttest{
simulated <- Y1.sim(N = 150, nX = 6)
RFmodel <- RFEAT(data = simulated, x = 1:6, y = 7, numStop = 10,
                  m = 50, s_mtry = "BRM", na.rm = TRUE)
plotRFEAT(RFmodel)
}

}
