% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemCategoryConstraint.R
\name{itemCategoryConstraint}
\alias{itemCategoryConstraint}
\title{Create item category constraints.}
\usage{
itemCategoryConstraint(
  nForms,
  nItems,
  itemCategories,
  operator = c("<=", "=", ">="),
  targetValues
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{nItems}{Number of items in the item pool.}

\item{itemCategories}{a factor representing the categories/grouping of the items}

\item{operator}{a character indicating which operator should be used in the
constraints, with three possible values: \code{"<="}, \code{"="},
or \code{">="}. See details for more information.}

\item{targetValues}{an integer vector representing the target number per category.
The order of the target values should correspond with the order of the levels
of the factor in \code{itemCategory}.}
}
\value{
A sparse matrix.
}
\description{
Create constraints related to item categories/groupings (as
represented by \code{itemCategories}). That is, the created
constraints assure that the number of items of each category per test form is either
(a) smaller or equal than (\code{operator = "<="}), (b) equal to
(\code{operator = "="}), or (c) greater than or equal to (\code{operator = ">="})
the corresponding \code{targetValues}.
}
\examples{
## constraints to make sure that there are at least 3 items of each item type
## in each test form
nItems <- 30
item_type <- factor(sample(1:3, size = nItems, replace = TRUE))
itemCategoryConstraint(2, nItems, item_type, ">=", targetValues = c(3, 3, 3))

}
