% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reuseMeta.R
\name{reuseMeta}
\alias{reuseMeta}
\title{Use meta data for a variable from another \code{GADSdat}.}
\usage{
reuseMeta(
  GADSdat,
  varName,
  other_GADSdat,
  other_varName = NULL,
  missingLabels = NULL,
  addValueLabels = FALSE
)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Name of the variable that should get the new meta data.}

\item{other_GADSdat}{\code{GADSdat} object imported via \code{eatGADS} including the desired meta information. Can also be a GADS db or an \code{all_GADSdat} object.}

\item{other_varName}{Name of the variable that should get the new meta data in the \code{other_GADSdat}.}

\item{missingLabels}{How should meta data for missing values be treated? If \code{NULL}, missing values are transferred as all other labels. If \code{"drop"}, missing labels are dropped (useful for imputed data). If \code{"leave"}, missing labels remain untouched. If \code{"only"}, all valid value labels are dropped.}

\item{addValueLabels}{Should only value labels be added and all other meta information retained?}
}
\value{
Returns the original object with updated meta data.
}
\description{
Transfer meta information from one \code{GADSdat} to another.
}
\details{
Transfer of meta information can mean substituting the complete meta information, only adding value labels, adding only
\code{"valid"} or adding only \code{"miss"} missing labels.
See the arguments \code{missingLabels} and \code{addValueLabels} for further information.
}
\examples{
# see createGADS vignette

}
