% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractMeta.R
\name{extractMeta}
\alias{extractMeta}
\title{Get Meta Data}
\usage{
extractMeta(GADSobject, vars = NULL)
}
\arguments{
\item{GADSobject}{Either a \code{GADSdat} object or a path to an existing \code{eatGADS} data base.}

\item{vars}{A character vector containing variable names. If \code{NULL} (default), all available meta information is returned.}
}
\value{
Returns a long format data frame with meta information.
}
\description{
Extract meta data (e.g. variable and values labels) from an \code{eatGADS} object. This can be a \code{GADSdat}, an \code{all_GADSdat},
a labels \code{data.frame}, or the path to an existing data base.
}
\details{
Meta data is stored tidily in all \code{GADSdat} objects as a separate long format data frame. This information can be extracted for a single or
multiple variables.
}
\examples{
# Extract Meta data from data base
db_path <- system.file("extdata", "pisa.db", package = "eatGADS")
extractMeta(db_path, vars = c("schtype", "sameteach"))

# Extract Meta data from loaded/imported GADS
extractMeta(pisa, vars = c("schtype", "sameteach"))

}
