% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{label_raster_stack}
\alias{label_raster_stack}
\title{Label data cubes with the week date for each band}
\usage{
label_raster_stack(x)
}
\arguments{
\item{x}{\code{RasterStack} or \code{RasterBrick}; original eBird Status and Trends
data cube with 52 bands, one for each week.}
}
\value{
A \code{RasterStack} or \code{RasterBrick} with names assigned for the dates in
the format of "wYYYY.MM.DD" per raster package constraints. The \verb{Raster*}
objects do not allow the names to start with a number, nor are they allowed
to contain "-", so it is not possible to store the date in an ISO compliant
format. Use \code{parse_raster_dates()} to convert the layer names to dates.
}
\description{
The data cubes are saved as GeoTIFFs, which don't allow for band labels. For
convenience, this function labels the layers of a data cube once it has been
loaded with the week dates for each band.
}
\examples{
\dontrun{
# download and load example abundance data
sp_path <- ebirdst_download("example_data")
abd <- load_raster(sp_path, "abundance")

# label
abd <- label_raster_stack(abd)
names(abd)
}
}
