% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_radar}
\alias{e_radar}
\alias{e_radar_}
\title{Radar}
\usage{
e_radar(
  e,
  serie,
  max = 100,
  name = NULL,
  legend = TRUE,
  rm_x = TRUE,
  rm_y = TRUE,
  ...,
  radar = list()
)

e_radar_(
  e,
  serie,
  max = 100,
  name = NULL,
  legend = TRUE,
  rm_x = TRUE,
  rm_y = TRUE,
  ...,
  radar = list()
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to plot.}

\item{max}{Maximum value.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}

\item{radar}{A \code{list} of options to pass to the \code{radar}
rather than the serie, see \href{https://echarts.apache.org/en/option.html#radar}{official documentation}
alternatively, use the \code{\link{e_radar_opts}}.}
}
\description{
Add a radar chart
}
\examples{
df <- data.frame(
  x = LETTERS[1:5],
  y = runif(5, 1, 5),
  z = runif(5, 3, 7)
)

df \%>\%
  e_charts(x) \%>\%
  e_radar(y, max = 7) \%>\%
  e_radar(z) \%>\%
  e_tooltip(trigger = "item")
}
